# Script Name: fra.py
# Description: FRA usage details in an Oracle DB
# Usage: python fra.py
# Author: Adityanath Dewoolkar
# Version: 1

# importing required modules
import cx_Oracle
import getpass
import os

# For conditional coloring
os.system("")
class style():
    RED = '\033[31m'
    GREEN = '\033[32m'
    RESET = '\033[0m'

# Prompt the user for a password without echoing
password = getpass.getpass(prompt = 'Enter SYSTEM password: ',  stream=None)
# Enter TNS string to connect
db_name = input("Enter DB name: ")


# Code for getting FRA usage details in an Oracle DB
try:
    con = cx_Oracle.connect("SYSTEM",password,db_name)
    cursor=con.cursor()
    head = ("FRA","TotalGB","FreeGB","Full%")
    for result in cursor.execute("SELECT NAME,(SPACE_LIMIT / 1024 / 1024 / 1024) Total_GB,((SPACE_LIMIT - SPACE_USED + SPACE_RECLAIMABLE) / 1024 / 1024 / 1024) AS Free_GB,ROUND((SPACE_USED - SPACE_RECLAIMABLE) / SPACE_LIMIT * 100, 1) AS Full_Percent  FROM V$RECOVERY_FILE_DEST"):
        result=str(result)
        pieces = result.split()
        pieces = pieces[3]
        free_percent = float(pieces[:-1])
        if free_percent > 80:
            print(head)
            print(style.RED + result.format(head) + style.RESET)
        else:
            print(head)
            print(style.GREEN + result.format(head) + style.RESET)
        break
    else:
        print(style.GREEN + "FRA is not set. Kindly check ASM/Filesystem usage details."+ style.RESET)

except cx_Oracle.DatabaseError as err:
    print("Script execution failed: ", err)
