# Script Name: rman.py
# Description: RMAN backup details in an Oracle DB
# Usage: python rman.py
# Author: Adityanath Dewoolkar
# Version: 1

# importing required modules
import cx_Oracle
import getpass
import os

# For conditional coloring
os.system("")
class style():
    RED = '\033[31m'
    GREEN = '\033[32m'
    RESET = '\033[0m'

# Prompt the user for a password without echoing
password = getpass.getpass(prompt = 'Enter SYSTEM password: ',  stream=None)
# Enter TNS string to connect
db_name = input("Enter DB name: ")


# Code for getting FRA usage details in an Oracle DB
try:
    con = cx_Oracle.connect("SYSTEM",password,db_name)
    cursor=con.cursor()
    head = ("StartTime","EndTime","BkpDevType","BkpType","Status","TimeTakenSeconds")
    cur = con.cursor()
    cur.execute("select to_char(start_time,'DD-Mon-YYYY HH24:MI:SS'),to_char(end_time,'DD-Mon-YYYY HH24:MI:SS'),output_device_type,INPUT_TYPE,status,elapsed_seconds from v$rman_backup_job_details where start_time>sysdate-7 order by 1")
    res = cur.fetchall()
    if not res:
        print(style.RED + "No RMAN backup in last 7 days"+ style.RESET)
    else:
        print(head)
        for row in res:
            #print(row)
            row=str(row)
            pieces=row.split()
            status=pieces[-2]
            if "FAIL" not in status:
                print(style.GREEN + row.format(head) + style.RESET)
            else:
                print(style.RED + row.format(head) + style.RESET)


except cx_Oracle.DatabaseError as err:
    print("Script execution failed: ", err)
