# Script Name: db_inventory.py
# Description: creating DB inventory by connecting mutiple oracle DB's. Oracle DB version should be 18 or +
# Usage: python db_inventory.py
# Author: Adityanath Dewoolkar
# Version: 1

# importing required modules
import cx_Oracle
import getpass
import os

# For conditional coloring
os.system("")
class style():
    RED = '\033[31m'
    GREEN = '\033[32m'
    YELLOW = '\033[33m'
    RESET = '\033[0m'


list = "conn_details.txt"
try:
    handle = open(list)
    head = ("DBType","Version","hostname","InstanceName","DBName","DBSize","ArchivelogMode","Flashback","StartupTime")
    print(head)
    for line in handle:
            line = line.rstrip()
            pieces = line.split(",")
            username = pieces[0]
            password = pieces[1]
            hostname = pieces[2]
            port = pieces[3]
            service = pieces[4]
            try:
                con = cx_Oracle.connect(username,password,hostname + ':' + port + '/' + service)
                cursor=con.cursor()
                for result in cursor.execute("select distinct 'Oracle,'||i.version_full||','||host_name||','||instance_name||','||d.name||','||(a.total_size + nvl(b.total_size,0))||','||log_mode||','||FLASHBACK_ON||','||STARTUP_TIME from v$database d, v$instance i,(select round(sum(bytes)/1024/1024/1024) total_size from dba_data_files) a ,(select round(sum(bytes)/1024/1024/1024) total_size from dba_temp_files) b"):
                    result=str(result)
                    print(style.YELLOW + result.format(head) + style.RESET)
            except cx_Oracle.DatabaseError as err:
                print(style.RED +"Script execution failed for :"+service+'=>', err )
except :
    print(style.RED + "Make sure conn_details.txt is present in this folder with names of backup output files"+ style.RESET)
