# Script Name: patch_info.py
# Description: Patchset details for an Oracle DB
# Usage: python patch_info.py
# Author: Adityanath Dewoolkar
# Version: 1

# importing required modules
import cx_Oracle
import getpass
import os

# For conditional coloring
os.system("")
class style():
    RED = '\033[31m'
    GREEN = '\033[32m'
    YELLOW = '\033[33m'
    RESET = '\033[0m'


# Prompt the user for a password without echoing
password = getpass.getpass(prompt = 'Enter SYSTEM password: ',  stream=None)
# Enter TNS string to connect
db_name = input("Enter DB name: ")

# Code for getting Tablespace usage details in an Oracle DB
try:
    con = cx_Oracle.connect("SYSTEM",password,db_name)
    cursor=con.cursor()
    head = ("DateTime","Action","Status","Description","PatchNumber","PatchType")
    print(head)
    for result in cursor.execute("SELECT TO_char(action_time, 'DD-MON-YYYY HH24:MI:SS') AS action_time,action,status, description, PATCH_ID,PATCH_TYPE FROM   sys.dba_registry_sqlpatch order by 1 "):
        result=str(result)
        print(style.YELLOW + result.format(head) + style.RESET)

except cx_Oracle.DatabaseError as err:
    print("Script execution failed: ", err)
